<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) exit();

$inv_id = (int)$_GET['id'];
// Fetch invoice and agency details
$inv_query = $conn->query("SELECT i.*, a.agency_name, a.owner_name, a.address, a.phone, a.email 
                           FROM invoices i JOIN agencies a ON i.agency_id = a.id 
                           WHERE i.id = $inv_id");

if($inv_query->num_rows == 0) die("Invoice not found.");
$inv = $inv_query->fetch_assoc();

// Determine dashboard link based on role
$dash_link = ($_SESSION['user_role'] == 'SuperAdmin') ? 'admin_dashboard.php' : 'dashboard.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice_INV-<?php echo str_pad($inv['id'], 5, '0', STR_PAD_LEFT); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --dark: #2e3751; --light-bg: #f8f9fc; }
        body { font-family: 'Poppins', sans-serif; background-color: #d1d9e6; margin: 0; padding: 40px 0; color: #444; }
        
        /* Action Bar */
        .action-bar { max-width: 850px; margin: 0 auto 20px; display: flex; justify-content: space-between; align-items: center; }
        .btn { padding: 12px 25px; border-radius: 10px; border: none; cursor: pointer; font-weight: 600; font-size: 14px; text-decoration: none; display: inline-flex; align-items: center; gap: 8px; transition: 0.3s; }
        .btn-dash { background: #fff; color: var(--dark); box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
        .btn-print { background: var(--primary); color: #fff; box-shadow: 0 4px 10px rgba(78, 115, 223, 0.3); }
        .btn:hover { transform: translateY(-2px); opacity: 0.9; }

        /* Invoice Container */
        .invoice-wrapper { 
            background: #fff; max-width: 850px; margin: auto; padding: 50px; border-radius: 20px; 
            box-shadow: 0 20px 50px rgba(0,0,0,0.1); position: relative; overflow: hidden; 
        }
        
        /* Decoration Ribbon */
        .ribbon { position: absolute; top: 0; right: 0; width: 150px; height: 150px; background: var(--primary); clip-path: polygon(100% 0, 0 0, 100% 100%); opacity: 0.05; }

        .header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 50px; }
        .brand h1 { margin: 0; color: var(--primary); font-size: 28px; font-weight: 700; letter-spacing: -1px; }
        .brand p { margin: 5px 0 0; color: #888; font-size: 13px; }
        
        .inv-meta { text-align: right; }
        .inv-meta h2 { margin: 0; color: var(--dark); font-size: 24px; text-transform: uppercase; letter-spacing: 2px; }
        .inv-meta p { margin: 3px 0; font-size: 14px; color: #666; }

        .billing-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 40px; margin-bottom: 40px; }
        .bill-box h4 { margin: 0 0 10px; color: var(--primary); text-transform: uppercase; font-size: 12px; letter-spacing: 1px; border-bottom: 2px solid #f1f5f9; padding-bottom: 5px; }
        .bill-box p { margin: 3px 0; font-size: 14px; line-height: 1.6; }

        /* Table Style */
        .items-table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        .items-table th { background: #f8f9fc; padding: 15px; text-align: left; font-size: 13px; color: #64748b; text-transform: uppercase; }
        .items-table td { padding: 20px 15px; border-bottom: 1px solid #f1f5f9; font-size: 15px; }
        
        .total-section { display: flex; justify-content: flex-end; }
        .total-box { background: var(--dark); color: #fff; padding: 20px 40px; border-radius: 15px; display: flex; gap: 30px; align-items: center; }
        .total-box span { font-size: 14px; opacity: 0.7; }
        .total-box b { font-size: 24px; }

        .footer { margin-top: 60px; text-align: center; border-top: 1px solid #eee; padding-top: 30px; }
        .footer p { font-size: 12px; color: #94a3b8; line-height: 1.8; }

        /* Status Badge */
        .status-badge { display: inline-block; padding: 5px 15px; border-radius: 50px; font-size: 12px; font-weight: 700; margin-top: 10px; }
        .unpaid { background: #fee2e2; color: #ef4444; }
        .paid { background: #dcfce7; color: #22c55e; }

        @media print {

    /* Force exact colors & layout */
    * {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
        box-shadow: none !important;
    }

    body {
        background: #fff !important;
        margin: 0;
        padding: 0;
        font-size: 12px;
        color: #000;
    }

    /* Hide non-print elements */
    .action-bar,
    .no-print,
    button {
        display: none !important;
    }

    /* Main invoice container */
    .invoice-wrapper {
        width: 100% !important;
        max-width: 90% !important;
        margin: 0 auto;
        padding: 20px;
        border: 1px solid #ddd;
        box-shadow: none !important;
        page-break-inside: avoid;
    }

    /* Prevent layout breaking */
    .invoice-header,
    .invoice-body,
    .invoice-footer {
        width: 100%;
        display: block;
        page-break-inside: avoid;
    }

    /* Headings */
    h1, h2, h3 {
        color: #000 !important;
        margin-bottom: 6px;
    }

    /* Tables */
    table {
        width: 100%;
        border-collapse: collapse;
    }

    table th,
    table td {
        border: 1px solid #ddd;
        padding: 8px;
        font-size: 12px;
    }

    /* Total Payable box */
    .total-box {
        background: #1f2a44 !important;
        color: #fff !important;
        padding: 14px;
        border-radius: 8px;
        float: right;
        margin-top: 20px;
        min-width: 250px;
    }

    /* Status badge */
    .status-badge {
        border: 1px solid #ccc;
        padding: 4px 10px;
        font-size: 11px;
        border-radius: 12px;
        display: inline-block;
    }

    /* Page control */
    @page {
        size: A4;
        margin: 15mm;
    }
}

    </style>
</head>
<body>

    <div class="action-bar">
        <a href="<?php echo $dash_link; ?>" class="btn btn-dash"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>
        <button class="btn btn-print" onclick="window.print()"><i class="fas fa-download"></i> Download / Print PDF</button>
    </div>

    <div class="invoice-wrapper">
        <div class="ribbon"></div>
        
        <div class="header">
            <div class="brand">
                <h1>TRAVEL SAAS</h1>
                <p>Cloud-Based Agency Solutions</p>
                <p style="color:#555; font-size:12px; margin-top:10px;">Sargodha, Punjab, Pakistan<br>tztravelandtours2@gmail.com</p>
            </div>
            <div class="inv-meta">
                <h2>INVOICE</h2>
                <p>#INV-<?php echo str_pad($inv['id'], 5, '0', STR_PAD_LEFT); ?></p>
                <p>Date: <?php echo date('d M Y', strtotime($inv['created_at'])); ?></p>
                <p><b>Due Date: <?php echo date('d M Y', strtotime($inv['due_date'])); ?></b></p>
                <span class="status-badge <?php echo ($inv['status'] == 'Paid' ? 'paid' : 'unpaid'); ?>">
                    ● <?php echo strtoupper($inv['status']); ?>
                </span>
            </div>
        </div>

        <div class="billing-grid">
            <div class="bill-box">
                <h4>Bill To</h4>
                <p><strong><?php echo $inv['agency_name']; ?></strong></p>
                <p><?php echo $inv['owner_name']; ?></p>
                <p><?php echo $inv['address']; ?></p>
            </div>
            <div class="bill-box" style="text-align: right;">
                <h4>Contact Details</h4>
                <p><?php echo $inv['email']; ?></p>
                <p><?php echo $inv['phone']; ?></p>
            </div>
        </div>

        <table class="items-table">
            <thead>
                <tr>
                    <th>Service Description</th>
                    <th style="text-align: right;">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <strong><?php echo $inv['description']; ?></strong><br>
                        <small style="color:#888;">Software Subscription for the period of <?php echo date('M Y'); ?></small>
                    </td>
                    <td style="text-align: right; font-weight: 600;">PKR <?php echo number_format($inv['amount']); ?></td>
                </tr>
            </tbody>
        </table>

        <div class="total-section">
            <div class="total-box">
                <span>TOTAL PAYABLE</span>
                <b>PKR <?php echo number_format($inv['amount']); ?></b>
            </div>
        </div>

        <div class="footer">
            <p><strong>Payment Instructions:</strong> Please transfer the amount to our bank account or via JazzCash/EasyPaisa.<br>
            Always mention Invoice #<b>INV-<?php echo str_pad($inv['id'], 5, '0', STR_PAD_LEFT); ?></b> in your payment proof.<br>
            Thank you for using Travel SaaS Portal!</p>
        </div>
    </div>

</body>
</html>