<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];
$client_id = (int)$_GET['id'];

// 1. Fetch Client Data (Security check: must belong to logged-in agency)
$stmt = $conn->prepare("SELECT * FROM clients WHERE id = ? AND agency_id = ?");
$stmt->bind_param("ii", $client_id, $agency_id);
$stmt->execute();
$client = $stmt->get_result()->fetch_assoc();

if(!$client) die("Client not found or Access Denied.");

// 2. Fetch Recent Enquiries for this client
$enquiries = $conn->query("SELECT * FROM queries WHERE client_id = $client_id ORDER BY id DESC LIMIT 5");

// 3. Fetch Recent Vouchers (Umrah)
$umrah_vouchers = $conn->query("SELECT id, created_at FROM umrah_vouchers WHERE client_id = $client_id ORDER BY id DESC");

// 4. Fetch Recent Vouchers (Tickets)
$ticket_vouchers = $conn->query("SELECT id, created_at FROM ticket_vouchers WHERE client_id = $client_id ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Client Profile | <?php echo $client['name']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg: #f8f9fc; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 40px; }
        .container { max-width: 1100px; margin: auto; }
        
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
        .btn-back { text-decoration: none; color: #64748b; font-weight: 600; font-size: 14px; }
        
        .profile-grid { display: grid; grid-template-columns: 1fr 2fr; gap: 30px; }
        
        /* Side Info Card */
        .card { background: #fff; padding: 25px; border-radius: 15px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); margin-bottom: 20px; }
        .avatar-circle { width: 80px; height: 80px; background: var(--primary); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 32px; font-weight: 700; margin-bottom: 15px; }
        
        .info-label { font-size: 11px; text-transform: uppercase; color: #94a3b8; font-weight: 700; letter-spacing: 1px; margin-top: 15px; display: block; }
        .info-value { font-size: 15px; color: var(--secondary); font-weight: 500; }
        
        /* History Section */
        h3 { font-size: 18px; margin-bottom: 20px; color: var(--secondary); display: flex; align-items: center; gap: 10px; }
        .history-list { list-style: none; }
        .history-item { display: flex; justify-content: space-between; align-items: center; padding: 15px; border-bottom: 1px solid #f1f5f9; }
        .history-item:last-child { border-bottom: none; }
        
        .badge { padding: 4px 10px; border-radius: 20px; font-size: 11px; font-weight: 600; text-transform: uppercase; }
        .badge-umrah { background: #dcfce7; color: #166534; }
        .badge-ticket { background: #e0e7ff; color: #3730a3; }
        
        .btn-action { padding: 8px 15px; border-radius: 8px; text-decoration: none; font-size: 12px; font-weight: 600; transition: 0.3s; }
        .btn-edit { background: #f1f5f9; color: var(--primary); }
        .btn-del { background: #fff5f5; color: #e74a3b; }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <div>
            <a href="clients.php" class="btn-back"><i class="fas fa-arrow-left"></i> Back to Clients</a>
            <h1 style="margin-top: 10px;">Client Overview</h1>
        </div>
        <div style="display:flex; gap:10px;">
            <a href="view_client_ledger.php?id=<?php echo $client_id; ?>" class="btn-action" style="background:var(--secondary); color:white;"><i class="fas fa-wallet"></i> View Khata/Ledger</a>
            <a href="edit_client.php?id=<?php echo $client_id; ?>" class="btn-action btn-edit"><i class="fas fa-edit"></i> Edit Profile</a>
            <a href="handle_client.php?delete=<?php echo $client_id; ?>" class="btn-action btn-del" onclick="return confirm('Delete this client and all their data permanently?')"><i class="fas fa-trash"></i> Delete</a>
        </div>
    </div>

    <div class="profile-grid">
        <!-- Sidebar: Personal Info -->
        <div>
            <div class="card" style="text-align: center; display: flex; flex-direction: column; align-items: center;">
                <div class="avatar-circle"><?php echo substr($client['name'], 0, 1); ?></div>
                <h2 style="margin-bottom: 5px;"><?php echo $client['name']; ?></h2>
                <span class="badge" style="background:#f1f5f9; color:#475569;">Registered Client</span>
            </div>

            <div class="card">
                <span class="info-label">Contact Details</span>
                <p class="info-value"><i class="fas fa-phone"></i> <?php echo $client['phone_number']; ?></p>
                <p class="info-value"><i class="fas fa-envelope"></i> <?php echo $client['email'] ?: 'N/A'; ?></p>
                
                <span class="info-label">Address</span>
                <p class="info-value"><?php echo $client['address'] ?: 'Not provided'; ?><br><?php echo $client['city']; ?></p>

                <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">

                <span class="info-label">Passport Info</span>
                <p class="info-value"><b>No:</b> <?php echo $client['passport_no'] ?: 'N/A'; ?></p>
                <p class="info-value"><b>Expiry:</b> <?php echo $client['passport_expiry'] != '0000-00-00' ? date('d M Y', strtotime($client['passport_expiry'])) : 'N/A'; ?></p>
            </div>
        </div>

        <!-- Main: Activity History -->
        <div>
            <!-- Recent Enquiries -->
            <div class="card">
                <h3><i class="fas fa-comments" style="color:var(--primary);"></i> Recent Enquiries</h3>
                <div class="history-list">
                    <?php while($q = $enquiries->fetch_assoc()): ?>
                    <div class="history-item">
                        <div>
                            <b><?php echo $q['service_type']; ?></b><br>
                            <small style="color:#94a3b8;"><?php echo $q['description']; ?></small>
                        </div>
                        <div style="text-align:right;">
                            <span class="badge" style="background:#fef3c7; color:#92400e;"><?php echo $q['status']; ?></span><br>
                            <small style="font-size: 10px;"><?php echo date('d M Y', strtotime($q['created_at'])); ?></small>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    <?php if($enquiries->num_rows == 0) echo "<p style='padding:15px; color:#94a3b8; font-size:14px;'>No enquiries yet.</p>"; ?>
                </div>
            </div>

            <!-- Vouchers History -->
            <div class="card">
                <h3><i class="fas fa-file-invoice" style="color:var(--primary);"></i> Vouchers & Quotes</h3>
                <div class="history-list">
                    <!-- Umrah -->
                    <?php while($uv = $umrah_vouchers->fetch_assoc()): ?>
                    <div class="history-item">
                        <div><span class="badge badge-umrah">Umrah</span> #UM-<?php echo $uv['id']; ?></div>
                        <a href="view_umrah_voucher.php?id=<?php echo $uv['id']; ?>" class="btn-action btn-edit">View Voucher</a>
                    </div>
                    <?php endwhile; ?>
                    
                    <!-- Tickets -->
                    <?php while($tv = $ticket_vouchers->fetch_assoc()): ?>
                    <div class="history-item">
                        <div><span class="badge badge-ticket">Ticket</span> #TK-<?php echo $tv['id']; ?></div>
                        <a href="view_ticket_voucher.php?id=<?php echo $tv['id']; ?>" class="btn-action btn-edit">View Voucher</a>
                    </div>
                    <?php endwhile; ?>

                    <?php if($umrah_vouchers->num_rows == 0 && $ticket_vouchers->num_rows == 0) echo "<p style='padding:15px; color:#94a3b8; font-size:14px;'>No vouchers created yet.</p>"; ?>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>