<?php 
include 'config.php'; 
if($_SESSION['user_role'] != 'AgencyOwner') { header("Location: dashboard.php"); exit(); }

$agency_id = $_SESSION['agency_id'];

// Fetch current staff
$staff_res = $conn->query("SELECT * FROM users WHERE agency_id = $agency_id AND role = 'Staff'");
$current_staff_count = $staff_res->num_rows;
$staff_limit = 2; // YOUR LIMIT
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Staff Management | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg: #f8f9fc; --danger: #e74a3b; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); display: flex; }
        .sidebar { width: 260px; background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .main-content { margin-left: 260px; width: calc(100% - 260px); padding: 40px; }
        .card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); }
        input { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 8px; }
        .btn { background: var(--primary); color: white; padding: 12px; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; width: 100%; }
        
        .limit-box { background: #fff5f5; border: 1px solid #feb2b2; padding: 20px; border-radius: 12px; text-align: center; color: var(--danger); }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th { text-align: left; color: #64748b; font-size: 11px; text-transform: uppercase; border-bottom: 1px solid #eee; padding: 10px; }
        td { padding: 15px 10px; border-bottom: 1px solid #f8f9fc; font-size: 14px; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div style="padding: 20px; font-weight: 600;"><?php echo AGENCY_NAME_LIVE; ?></div>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="staff.php" class="nav-link active"><i class="fas fa-user-tie"></i> Manage Staff</a>
        <a href="logout.php" class="nav-link"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main-content">
        <h1>Staff Management</h1>
        <p style="color: #64748b; margin-bottom: 30px;">Account Usage: <b><?php echo $current_staff_count; ?> / <?php echo $staff_limit; ?></b> seats occupied.</p>

        <div style="display: grid; grid-template-columns: 1fr 1.5fr; gap: 30px;">
            
            <!-- ADD STAFF SECTION -->
            <div>
                <?php if($current_staff_count < $staff_limit): ?>
                    <div class="card">
                        <h3>Add New Agent</h3>
                        <form action="handle_staff.php" method="POST">
                            <label style="font-size:12px;">Full Name</label>
                            <input type="text" name="name" placeholder="Agent Name" required>
                            
                            <label style="font-size:12px;">Email (Login)</label>
                            <input type="email" name="email" placeholder="agent@agency.com" required>
                            
                            <label style="font-size:12px;">Set Password</label>
                            <input type="password" name="password" required>
                            
                            <button type="submit" class="btn">Create Account</button>
                        </form>
                    </div>
                <?php else: ?>
                    <div class="limit-box">
                        <i class="fas fa-lock" style="font-size: 30px; margin-bottom: 10px;"></i>
                        <h4>Staff Limit Reached</h4>
                        <p style="font-size: 13px;">Your current plan only allows <?php echo $staff_limit; ?> employees. Delete an existing agent or contact admin to upgrade.</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- STAFF LIST SECTION -->
            <div class="card">
                <h3>Current Staff</h3>
                <table>
                    <thead>
                        <tr><th>Name</th><th>Email</th><th>Action</th></tr>
                    </thead>
                    <tbody>
                        <?php while($row = $staff_res->fetch_assoc()): ?>
                        <tr>
                            <td><b><?php echo $row['name']; ?></b></td>
                            <td><?php echo $row['email']; ?></td>
                            <td>
                                <a href="handle_staff.php?delete=<?php echo $row['id']; ?>" style="color:var(--danger);" onclick="return confirm('Remove this agent?')">
                                    <i class="fas fa-trash-alt"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        <?php if($current_staff_count == 0) echo "<tr><td colspan='3' style='text-align:center; padding:20px; color:#94a3b8;'>No staff accounts created yet.</td></tr>"; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</body>
</html>