<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];
$agency_data = $conn->query("SELECT * FROM agencies WHERE id = $agency_id")->fetch_assoc();
if($_SESSION['user_role'] == 'Staff') {
    die("Access Denied: You do not have permission to view financial records.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Agency Settings | White-Labeling</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg-color: #f8f9fc; --sidebar-width: 260px; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg-color); display: flex; }
        .sidebar { width: var(--sidebar-width); background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 40px; }
        
        .card { background: #fff; padding: 30px; border-radius: 15px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); max-width: 700px; }
        .form-group { margin-bottom: 20px; }
        label { display: block; font-size: 13px; font-weight: 600; color: #64748b; margin-bottom: 8px; }
        input, textarea { width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 10px; font-size: 14px; }
        .btn-save { background: var(--primary); color: #fff; padding: 12px 25px; border: none; border-radius: 10px; cursor: pointer; font-weight: 600; width: 100%; }
        
        .logo-preview { width: 150px; height: 80px; border: 1px dashed #cbd5e1; border-radius: 8px; margin-bottom: 10px; display: flex; align-items: center; justify-content: center; overflow: hidden; }
        .logo-preview img { max-width: 100%; max-height: 100%; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div style="padding: 20px; font-weight: 600;"><?php echo AGENCY_NAME_LIVE; ?></div>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="settings.php" class="nav-link active" style="background: rgba(255,255,255,0.1); color: #fff;"><i class="fas fa-cog"></i> Agency Settings</a>
        <a href="logout.php" class="nav-link"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main-content">
        <h1>Agency Branding</h1>
        <p style="color: #64748b; margin-bottom: 30px;">Customize how your agency appears on vouchers and posters.</p>

        <div class="card">
            <form action="handle_settings.php" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label>Agency Logo (PNG/JPG)</label>
                    <div class="logo-preview">
                        <img src="<?php echo AGENCY_LOGO_LIVE; ?>" id="previewImg">
                    </div>
                    <input type="file" name="agency_logo" accept="image/*" onchange="previewFile(this)">
                </div>

                <div class="form-group">
                    <label>Public Agency Name</label>
                    <input type="text" name="agency_name" value="<?php echo $agency_data['agency_name']; ?>" required>
                </div>

                <div class="form-group">
                    <label>Contact Phone (Separated by |)</label>
                    <input type="text" name="phone" value="<?php echo $agency_data['phone']; ?>" placeholder="e.g. 0300-1234567 | 0321-7654321">
                </div>

                <div class="form-group">
                    <label>Office Address</label>
                    <textarea name="address" rows="3"><?php echo $agency_data['address']; ?></textarea>
                </div>

                <button type="submit" class="btn-save">Update Branding Details</button>
            </form>
        </div>
    </div>

    <script>
        function previewFile(input){
            var file = $("input[type=file]").get(0).files[0];
            if(file){
                var reader = new FileReader();
                reader.onload = function(){ $("#previewImg").attr("src", reader.result); }
                reader.readAsDataURL(file);
            }
        }
    </script>
</body>
</html>