<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) exit();

$agency_id = $_SESSION['agency_id'];
$invoices = $conn->query("SELECT * FROM invoices WHERE agency_id = $agency_id ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Billing | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg-color: #f8f9fc; --sidebar-width: 260px; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg-color); display: flex; }
        .sidebar { width: var(--sidebar-width); background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 40px; }
        .card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); }
        table { width: 100%; border-collapse: collapse; }
        th { text-align: left; color: #64748b; font-size: 12px; padding-bottom: 10px; border-bottom: 1px solid #eee; }
        td { padding: 15px 0; border-bottom: 1px solid #f8f9fc; font-size: 14px; }
        .status-paid { color: #1cc88a; font-weight: 600; }
        .status-unpaid { color: #e74a3b; font-weight: 600; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div style="padding: 20px; font-weight: 600;"><?php echo AGENCY_NAME_LIVE; ?></div>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="my_billing.php" class="nav-link active" style="background: rgba(255,255,255,0.1); color: #fff;"><i class="fas fa-file-invoice-dollar"></i> Billing & Invoices</a>
        <a href="logout.php" class="nav-link"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main-content">
        <h1>Billing History</h1>
        <div class="card" style="margin-bottom: 20px; background: #4e73df; color: white;">
            <small>CURRENT OUTSTANDING BALANCE</small>
            <h2>PKR <?php 
                $bal = $conn->query("SELECT balance_due FROM agencies WHERE id = $agency_id")->fetch_assoc();
                echo number_format($bal['balance_due']); 
            ?></h2>
        </div>

        <div class="card">
            <table>
                <thead>
                    <tr><th>Invoice #</th><th>Description</th><th>Amount</th><th>Due Date</th><th>Status</th></tr>
                </thead>
                <tbody>
                    <?php while($row = $invoices->fetch_assoc()): ?>
                    <tr>
                        <td>#INV-<?php echo $row['id']; ?></td>
                        <td><?php echo $row['description']; ?></td>
                        <td>PKR <?php echo number_format($row['amount']); ?></td>
                        <td><?php echo date('d M Y', strtotime($row['due_date'])); ?></td>
                        <td class="<?php echo ($row['status'] == 'Paid') ? 'status-paid' : 'status-unpaid'; ?>">
                            <?php echo $row['status']; ?>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>