<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];

// Improved Query: Joining with Airlines table to get the name and logo
$query_sql = "SELECT g.*, a.name as airline_name, a.logo_path 
              FROM group_tickets g 
              JOIN airlines a ON g.airline_id = a.id 
              WHERE g.status = 'Available' AND g.available_seats > 0 
              ORDER BY g.id DESC";
$deals = $conn->query($query_sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>B2B Marketplace | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --success: #1cc88a; --bg-color: #f8f9fc; --sidebar-width: 260px; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg-color); display: flex; }
        .sidebar { width: var(--sidebar-width); background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .active { background: rgba(255,255,255,0.1); color: #fff; }
        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 40px; }
        
        .card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); }
        
        /* Horizontal Table Styling */
        table { width: 100%; border-collapse: collapse; }
        th { text-align: left; padding: 15px; background: #f8f9fc; color: #64748b; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; }
        td { padding: 15px; border-bottom: 1px solid #f1f5f9; font-size: 13px; }
        
        .airline-logo { height: 30px; vertical-align: middle; margin-right: 10px; }
        .trip-badge { padding: 3px 8px; border-radius: 4px; font-size: 10px; font-weight: 600; text-transform: uppercase; }
        .one-way { background: #e0e7ff; color: #4338ca; }
        .return { background: #dcfce7; color: #166534; }
        
        .price { font-size: 16px; font-weight: 700; color: var(--success); }
        .baggage { font-size: 11px; color: #64748b; display: block; }
        
        .btn-book { background: var(--primary); color: white; border: none; padding: 8px 15px; border-radius: 6px; cursor: pointer; font-weight: 600; font-size: 12px; }
        input[type="number"] { padding: 8px; border: 1px solid #ddd; border-radius: 6px; width: 60px; font-size: 12px; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div style="padding: 0 25px 30px; font-weight: 600; font-size: 18px;"><i class="fas fa-plane-departure text-primary"></i> TRAVEL SAAS</div>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="clients.php" class="nav-link "><i class="fas fa-users"></i> My Clients</a>
        <a href="queries.php" class="nav-link "><i class="fas fa-question-circle"></i> Enquiries</a>
        <a href="marketplace.php" class="nav-link active"><i class="fas fa-shopping-cart"></i> B2B Marketplace</a>
        <a href="umrah_vouchers.php" class="nav-link"><i class="fas fa-kaaba"></i> Umrah Vouchers</a>
        <a href="ticket_vouchers.php" class="nav-link "><i class="fas fa-ticket-alt"></i> Ticket Vouchers</a>
        <a href="posters.php" class="nav-link"><i class="fas fa-image"></i> Poster Maker</a>
        <a href="ledger.php" class="nav-link"><i class="fas fa-wallet"></i> My Accounts</a>
        <?php if($_SESSION['user_role'] == 'AgencyOwner'): ?>
            <a href="staff.php" class="nav-link"><i class="fas fa-user-tie"></i> Manage Staff</a>
            <a href="agency_profile.php" class="nav-link"><i class="fas fa-cog"></i> Settings</a>
        <?php endif; ?>
        <div style="position: absolute; bottom: 20px; width: 100%;">
            <a href="logout.php" class="nav-link" style="color: #ff7675;"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
    </div>

    <div class="main-content">
        <h1>B2B Ticket Marketplace</h1>
        <p style="color: #64748b; margin-bottom: 30px;">Exclusive live group deals. Request seats before they sell out.</p>

        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th>Airline & Type</th>
                        <th>Route</th>
                        <th>Dates</th>
                        <th>Baggage</th>
                        <th>Available</th>
                        <th>Price (Seat)</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $deals->fetch_assoc()): ?>
                    <tr>
                        <td>
                            <img src="<?php echo $row['logo_path']; ?>" class="airline-logo">
                            <b><?php echo $row['airline_name']; ?></b><br>
                            <span class="trip-badge <?php echo ($row['trip_type'] == 'Return' ? 'return' : 'one-way'); ?>">
                                <?php echo $row['trip_type']; ?>
                            </span>
                        </td>
                        <td>
                            <b style="font-size: 14px;"><?php echo $row['route']; ?></b>
                        </td>
                        <td>
                            <i class="fas fa-plane-departure" style="font-size: 11px; color: #94a3b8;"></i> 
                            <?php echo date('d M Y', strtotime($row['travel_date'])); ?>
                            <?php if($row['trip_type'] == 'Return'): ?>
                                <br>
                                <i class="fas fa-plane-arrival" style="font-size: 11px; color: #94a3b8;"></i> 
                                <?php echo date('d M Y', strtotime($row['return_date'])); ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="baggage">Dep: <?php echo $row['dep_baggage']; ?></span>
                            <?php if($row['trip_type'] == 'Return'): ?>
                                <span class="baggage">Ret: <?php echo $row['ret_baggage']; ?></span>
                            <?php endif; ?>
                        </td>
                        <td><b style="color: var(--primary);"><?php echo $row['available_seats']; ?></b> Seats</td>
                        <td class="price">PKR <?php echo number_format($row['price_per_seat']); ?></td>
                        <td>
                            <form action="handle_group_booking.php" method="POST" style="display:flex; gap: 5px; align-items:center;">
                                <input type="hidden" name="ticket_id" value="<?php echo $row['id']; ?>">
                                <input type="number" name="seats" value="1" min="1" max="<?php echo $row['available_seats']; ?>" required>
                                <button type="submit" class="btn-book">Request</button>
                            </form>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>