<?php 
include 'config.php'; 
// FIXED: Allow both SuperAdmin and AgencyOwner to manage airlines
if(!isset($_SESSION['user_id']) || ($_SESSION['user_role'] != 'SuperAdmin' && $_SESSION['user_role'] != 'AgencyOwner')) { 
    header("Location: dashboard.php"); exit(); 
}

// 1. Fetch existing airlines
$airlines = $conn->query("SELECT * FROM airlines ORDER BY name ASC");

// 2. Handle Deletion
if(isset($_GET['delete'])){
    $id = (int)$_GET['delete'];
    $res = $conn->query("SELECT logo_path FROM airlines WHERE id = $id");
    if($res->num_rows > 0){
        $file = $res->fetch_assoc()['logo_path'];
        if(file_exists($file)) { unlink($file); }
    }
    $conn->query("DELETE FROM airlines WHERE id = $id");
    header("Location: manage_airlines.php?msg=deleted");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Airlines | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg: #f8f9fc; --danger: #e74a3b; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 40px; }
        .container { max-width: 1000px; margin: auto; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
        .card { background: #fff; padding: 30px; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); margin-bottom: 30px; }
        label { display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px; text-transform: uppercase; }
        input { width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 12px; font-size: 14px; outline: none; }
        .btn-upload { background: var(--primary); color: white; border: none; padding: 12px 30px; border-radius: 12px; font-weight: 700; cursor: pointer; transition: 0.3s; }
        .airline-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(180px, 1fr)); gap: 20px; }
        .airline-card { background: white; border-radius: 15px; padding: 20px; text-align: center; border: 1px solid #edf2f7; position: relative; }
        .airline-card img { height: 45px; max-width: 100%; object-fit: contain; margin-bottom: 10px; }
        .delete-icon { position: absolute; top: 10px; right: 10px; color: #cbd5e1; cursor: pointer; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div>
                <a href="posters.php" style="text-decoration:none; color:#64748b; font-size:14px;"><i class="fas fa-arrow-left"></i> Back to Studio</a>
                <h1 style="margin-top: 10px;">Airlines & Logos</h1>
            </div>
        </div>

        <div class="card">
            <form action="handle_airlines.php" method="POST" enctype="multipart/form-data">
                <div style="display: grid; grid-template-columns: 1.5fr 1.5fr 1fr; gap: 20px; align-items: flex-end;">
                    <div>
                        <label>Airline Name</label>
                        <input type="text" name="name" placeholder="e.g. Emirates" required>
                    </div>
                    <div>
                        <label>Logo (Transparent PNG)</label>
                        <input type="file" name="logo" required>
                    </div>
                    <button type="submit" name="add_airline" class="btn-upload">Add to List</button>
                </div>
            </form>
        </div>

        <div class="airline-grid">
            <?php while($row = $airlines->fetch_assoc()): ?>
                <div class="airline-card">
                    <a href="?delete=<?php echo $row['id']; ?>" class="delete-icon" onclick="return confirm('Delete logo?')"><i class="fas fa-times-circle"></i></a>
                    <img src="<?php echo $row['logo_path']; ?>">
                    <b><?php echo $row['name']; ?></b>
                </div>
            <?php endwhile; ?>
        </div>
    </div>
</body>
</html>