<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'SuperAdmin') { 
    header("Location: dashboard.php"); exit(); 
}

// Fetch all agencies except the Super Admin portal itself
$agencies = $conn->query("SELECT * FROM agencies WHERE id > 1 ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Agencies | Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg-color: #f8f9fc; --sidebar-width: 260px; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg-color); display: flex; }
        .sidebar { width: var(--sidebar-width); background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .nav-link:hover, .active { background: rgba(255,255,255,0.1); color: #fff; }
        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 40px; }
        .card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); margin-bottom: 30px; }
        .form-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; }
        input, select { width: 100%; padding: 12px; margin-top: 5px; border: 1px solid #ddd; border-radius: 8px; }
        label { font-size: 13px; font-weight: 500; color: #64748b; }
        .btn { background: var(--primary); color: #fff; padding: 12px 25px; border: none; border-radius: 8px; cursor: pointer; font-weight: 500; margin-top: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th { text-align: left; padding: 15px; background: #f1f5f9; color: #64748b; font-size: 13px; text-transform: uppercase; }
        td { padding: 15px; border-bottom: 1px solid #f1f5f9; font-size: 14px; }
        .status-badge { padding: 4px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; text-align: center; display: inline-block; min-width: 80px;}
        .active-badge { background: #dcfce7; color: #166534; }
        .expired-badge { background: #fee2e2; color: #991b1b; } /* Also used for Suspended */
        .sidebar-brand {
            padding: 0 25px 30px;
            font-size: 20px;
            font-weight: 600;
            display: flex;
            align-items: center;
            color: #fff;
            text-decoration: none;
        }
        .sidebar-brand i { margin-right: 10px; color: var(--primary); }
    </style>
</head>
<body>

    <div class="sidebar">
        <a href="#" class="sidebar-brand">
            <i class="fas fa-plane-departure"></i>
            <span>TRAVEL SAAS</span>
        </a>
        
        <ul class="nav-menu">
    <?php if($_SESSION['user_role'] == 'SuperAdmin'): ?>
        <!-- SUPER ADMIN MENU -->
         <li class="nav-item"><a href="dashboard.php" class="nav-link "><i class="fas fa-home"></i> Dashboard</a></li>
        <li class="nav-item"><a href="admin_dashboard.php" class="nav-link"><i class="fas fa-chart-line"></i> SaaS Overview</a></li>
        <li class="nav-item"><a href="manage_agencies.php" class="nav-link active"><i class="fas fa-building"></i> Manage Agencies</a></li>
        <li class="nav-item"><a href="saas_revenue.php" class="nav-link"><i class="fas fa-file-invoice-dollar"></i> Revenue & Payments</a></li>
         <li class="nav-item"><a href="generate_invoice.php" class="nav-link" style="color: #1cc88a;"><i class="fas fa-file-invoice-dollar"></i> Generate New Bill</a></li>
         <li class="nav-item"><a href="admin_group_tickets.php" class="nav-link" style="color: #3498db;"><i class="fas fa-plane-arrival"></i> B2B Group Inventory</a></li>
    <li class="nav-item"><a href="broadcast.php" class="nav-link"><i class="fas fa-bullhorn"></i> Send Announcements</a></li>
    <li class="nav-item"><a href="profile.php" class="nav-link"><i class="fas fa-user-shield"></i> My Profile</a></li>
    <?php else: ?>
        <!-- AGENCY MENU -->
        <li class="nav-item"><a href="dashboard.php" class="nav-link active"><i class="fas fa-home"></i> Dashboard</a></li>
        <li class="nav-item"><a href="clients.php" class="nav-link"><i class="fas fa-users"></i> My Clients</a></li>
        <li class="nav-item"><a href="queries.php" class="nav-link"><i class="fas fa-question-circle"></i> Enquiries</a></li>
        <?php if($_SESSION['user_role'] == 'AgencyOwner'): ?>
    <li class="nav-item"><a href="staff.php" class="nav-link"><i class="fas fa-user-tie"></i> Manage Staff</a></li>
<?php endif; ?>
        <li class="nav-item"><a href="marketplace.php" class="nav-link" style="background: rgba(28, 200, 138, 0.1); color: #1cc88a;"><i class="fas fa-shopping-cart"></i> B2B Marketplace</a></li>
        <li class="nav-item"><a href="umrah_vouchers.php" class="nav-link"><i class="fas fa-kaaba"></i> Umrah Vouchers</a></li>
        <li class="nav-item"><a href="ticket_vouchers.php" class="nav-link"><i class="fas fa-ticket-alt"></i> Ticket Vouchers</a></li>
        <li class="nav-item"><a href="posters.php" class="nav-link"><i class="fas fa-image"></i> Poster Maker</a></li>
        <li class="nav-item"><a href="ledger.php" class="nav-link"><i class="fas fa-wallet"></i> Clients Account</a></li>
        <li class="nav-item">
    <a href="agency_profile.php" class="nav-link" style="background: rgba(78, 115, 223, 0.1); color: #4e73df;">
        <i class="fas fa-cog"></i> Agency Settings
    </a>
</li>
    <?php endif; ?>
</ul>

        <?php if($_SESSION['user_role'] == 'SuperAdmin'): ?>

        <?php endif; ?>

        <div style="position: absolute; bottom: 20px; width: 100%;">
            <li class="nav-item" style="list-style: none;"><a href="logout.php" class="nav-link" style="color: #ff7675;"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </div>
    </div>

    <div class="main-content">
        <h1>Agency Management</h1>
        <div class="card">
            <h3><i class="fas fa-plus-circle"></i> Register New Agency</h3>
            <form action="handle_agency.php" method="POST">
                <div class="form-grid">
                    <div><label>Agency Name</label><input type="text" name="agency_name" required></div>
                    <div><label>Owner Full Name</label><input type="text" name="owner_name" required></div>
                    <div><label>Login Email</label><input type="email" name="email" required></div>
                    <div><label>Set Password</label><input type="password" name="password" required></div>
                    <div><label>Phone Number</label><input type="text" name="phone"></div>
                    <div><label>Subscription Expiry</label><input type="date" name="expiry_date" required></div>
                </div>
                <button type="submit" name="add_agency" class="btn">Create Agency Account</button>
            </form>
        </div>

        <div class="card">
            <h3>Existing Agencies</h3>
            <table>
                <thead>
                    <tr>
                        <th>Agency Name</th>
                        <th>Owner / Email</th>
                        <th>Vouchers Left (Monthly)</th>
                        <th>Balance (You Owe)</th>
                        <th>Expiry Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $agencies->fetch_assoc()): 
                        $is_expired = strtotime($row['expiry_date']) < time();
                        $status = $row['status']; 
                        $balance = $row['balance_due'];

                        // Status Logic
                        if ($status == 'Suspended') {
                            $display_status = "Suspended";
                            $badge_class = "expired-badge"; 
                        } elseif ($is_expired) {
                            $display_status = "Expired";
                            $badge_class = "expired-badge"; 
                        } else {
                            $display_status = "Active";
                            $badge_class = "active-badge"; 
                        }
                        $t_left = $row['max_tickets'] - $row['tickets_used'];
        $u_left = $row['max_umrah'] - $row['umrah_used'];
        $p_left = $row['max_posters'] - $row['posters_generated'];
                    ?>
                     
        
                    <tr>
                        <td><b><?php echo $row['agency_name']; ?></b></td>
                        <td><?php echo $row['owner_name']; ?><br><small><?php echo $row['email']; ?></small></td>
                         <td>
            <small style="display:block;">Tickets: <b><?php echo $t_left; ?></b></small>
            <small style="display:block;">Umrah: <b><?php echo $u_left; ?></b></small>
            <small style="display:block;">Posters: <b><?php echo $p_left; ?></b></small>
        </td>
                        <td>
                            <span style="font-weight: 600; color: <?php echo ($balance > 0 ? '#e74a3b' : '#1cc88a'); ?>">
                                PKR <?php echo number_format($balance); ?>
                            </span>
                            <a href="agency_ledger.php?id=<?php echo $row['id']; ?>" style="margin-left: 8px; color: #4e73df;"><i class="fas fa-book"></i></a>
                        </td>
                        <td><?php echo date('M d, Y', strtotime($row['expiry_date'])); ?></td>
                        <td><span class="status-badge <?php echo $badge_class; ?>"><?php echo $display_status; ?></span></td>
                        <td><a href="edit_agency.php?id=<?php echo $row['id']; ?>" style="color: var(--primary);"><i class="fas fa-edit"></i> Edit</a></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>