<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) exit();

$type = $_GET['type'] ?? 'OneWay';
$airlines = $conn->query("SELECT * FROM airlines ORDER BY name ASC");
$airline_data = [];
while($a = $airlines->fetch_assoc()){ $airline_data[] = $a; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Generate <?php echo $type; ?> Poster</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --bg: #f4f7f6; }
        body { font-family: 'Poppins', sans-serif; background: var(--bg); margin: 0; display: flex; height: 100vh; overflow: hidden; }
        .sidebar-form { width: 400px; background: white; padding: 30px; overflow-y: auto; box-shadow: 10px 0 30px rgba(0,0,0,0.05); }
        .preview-area { flex: 1; display: flex; align-items: center; justify-content: center; background: #d1d9e6; position: relative; }
        
        label { display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-top: 15px; text-transform: uppercase; }
        input, select { width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 10px; margin-top: 5px; font-size: 14px; }
        
        canvas { max-height: 90vh; max-width: 90%; border-radius: 10px; box-shadow: 0 20px 50px rgba(0,0,0,0.2); }
        .btn-download { background: #1cc88a; color: white; border: none; padding: 15px; width: 100%; border-radius: 10px; font-weight: 700; cursor: pointer; margin-top: 20px; }
    </style>
</head>
<body>

    <div class="sidebar-form">
        <a href="posters.php" style="text-decoration:none; color:#64748b; font-size:12px;"><i class="fas fa-arrow-left"></i> Back</a>
        <h2 style="margin-top:10px;"><?php echo $type; ?> Poster</h2>
        
        <label>Select Background</label>
        <select id="bg_select" onchange="updatePreview()">
            <option value="assets/kaaba.png">Khana Kaaba (Umrah)</option>
            <option value="assets/dome.png">Green Dome (Madinah)</option>
        </select>

        <label>Airline</label>
        <select id="airline_select" onchange="updatePreview()">
            <?php foreach($airline_data as $air): ?>
                <option value="<?php echo $air['logo_path']; ?>"><?php echo $air['name']; ?></option>
            <?php endforeach; ?>
        </select>

        <label>Route / Sector</label>
        <input type="text" id="route" placeholder="e.g. Lahore - Jeddah" oninput="updatePreview()">

        <label>Travel Date</label>
        <input type="text" id="date1" placeholder="e.g. 15 Jan 2026" oninput="updatePreview()">

        <?php if($type == 'Return'): ?>
            <label>Return Date</label>
            <input type="text" id="date2" placeholder="e.g. 30 Jan 2026" oninput="updatePreview()">
        <?php endif; ?>

        <label>Total Fare (PKR)</label>
        <input type="text" id="price" placeholder="e.g. 145,000/-" oninput="updatePreview()">

        <label>Baggage Detail</label>
        <input type="text" id="baggage" placeholder="e.g. 30KG + 7KG" oninput="updatePreview()">

        <button class="btn-download" onclick="download()"><i class="fas fa-download"></i> Download & Log</button>
    </div>

    <div class="preview-area">
        <canvas id="posterCanvas" width="1080" height="1350"></canvas>
    </div>

    <script>
        const canvas = document.getElementById('posterCanvas');
        const ctx = canvas.getContext('2d');
        
        const imgBg = new Image();
        const imgLogo = new Image();
        const imgAgencyLogo = new Image();

        function updatePreview() {
            imgBg.src = document.getElementById('bg_select').value;
            imgLogo.src = document.getElementById('airline_select').value;
            imgAgencyLogo.src = '<?php echo AGENCY_LOGO_LIVE; ?>';

            imgBg.onload = draw;
            imgLogo.onload = draw;
            imgAgencyLogo.onload = draw;
        }

        function draw() {
            ctx.clearRect(0,0,1080,1350);
            
            // 1. Draw Background
            ctx.drawImage(imgBg, 0, 0, 1080, 1350);

            // 2. Overlay Gradient for readability
            let grad = ctx.createLinearGradient(0, 0, 0, 1350);
            grad.addColorStop(0, 'rgba(0,0,0,0.3)');
            grad.addColorStop(0.5, 'rgba(0,0,0,0)');
            grad.addColorStop(1, 'rgba(0,0,0,0.8)');
            ctx.fillStyle = grad;
            ctx.fillRect(0,0,1080,1350);

            // 3. Draw Airline Logo (Top Right)
            ctx.drawImage(imgLogo, 850, 50, 180, 80);

            // 4. Draw Route
            ctx.fillStyle = "white";
            ctx.textAlign = "center";
            ctx.font = "bold 80px Poppins";
            ctx.fillText(document.getElementById('route').value.toUpperCase() || "ROUTE HERE", 540, 850);

            // 5. Draw Dates
            ctx.font = "600 40px Poppins";
            let dateStr = "Date: " + document.getElementById('date1').value;
            if(document.getElementById('date2')) dateStr += " | Ret: " + document.getElementById('date2').value;
            ctx.fillText(dateStr, 540, 930);

            // 6. Draw Price Box
            ctx.fillStyle = "#f1c40f";
            ctx.font = "bold 120px Poppins";
            ctx.fillText("PKR " + (document.getElementById('price').value || "000,000"), 540, 1080);

            // 7. Baggage
            ctx.fillStyle = "white";
            ctx.font = "500 35px Poppins";
            ctx.fillText("Baggage: " + (document.getElementById('baggage').value || "Included"), 540, 1150);

            // 8. Footer Branding (Agency Info)
            ctx.fillStyle = "rgba(255,255,255,0.95)";
            ctx.fillRect(0, 1220, 1080, 130);
            
            ctx.fillStyle = "#1e293b";
            ctx.textAlign = "left";
            ctx.font = "bold 45px Poppins";
            ctx.fillText("<?php echo AGENCY_NAME_LIVE; ?>", 50, 1300);
            
            ctx.textAlign = "right";
            ctx.fillText("<?php echo AGENCY_PHONE_LIVE; ?>", 1030, 1300);
        }

        function download() {
            // Log the download to subtract from limit
            fetch('log_poster.php');
            
            const link = document.createElement('a');
            link.download = 'Fare-Poster.png';
            link.href = canvas.toDataURL('image/png');
            link.click();
        }

        window.onload = updatePreview;
    </script>
</body>
</html>