<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];
$user_id = $_SESSION['user_id'];

// 1. Fetch Agency Public Data
$agency = $conn->query("SELECT * FROM agencies WHERE id = $agency_id")->fetch_assoc();

// 2. Fetch User Login Data
$user = $conn->query("SELECT * FROM users WHERE id = $user_id")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Agency Settings | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg: #f8f9fc; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); display: flex; }
        
        .sidebar { width: 260px; background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .main-content { margin-left: 260px; width: calc(100% - 260px); padding: 40px; }
        
        .card { background: #fff; padding: 30px; border-radius: 15px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); margin-bottom: 30px; }
        .section-title { font-size: 18px; font-weight: 600; color: var(--secondary); margin-bottom: 20px; display: flex; align-items: center; gap: 10px; }
        
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        label { display: block; font-size: 13px; font-weight: 600; color: #64748b; margin-bottom: 8px; }
        input, textarea { width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 10px; font-size: 14px; outline: none; }
        
        .logo-preview-box { border: 2px dashed #cbd5e1; border-radius: 12px; padding: 20px; text-align: center; margin-bottom: 20px; }
        .logo-preview-box img { max-height: 100px; max-width: 200px; display: block; margin: 10px auto; border-radius: 8px; }
        
        .btn-save { background: var(--primary); color: #fff; border: none; padding: 15px 30px; border-radius: 10px; cursor: pointer; font-weight: 600; width: 100%; margin-top: 10px; transition: 0.3s; }
        .btn-save:hover { opacity: 0.9; transform: translateY(-2px); }
        
        .alert { padding: 15px; border-radius: 10px; margin-bottom: 20px; font-size: 14px; display: none; }
        .alert-success { background: #dcfce7; color: #15803d; border: 1px solid #b9f6ca; }
        .sidebar-brand {
            padding: 0 25px 30px;
            font-size: 20px;
            font-weight: 600;
            display: flex;
            align-items: center;
            color: #fff;
            text-decoration: none;
        }
        .sidebar-brand i { margin-right: 10px; color: var(--primary); }
    </style>
</head>
<body>

    <div class="sidebar">
        <a href="#" class="sidebar-brand">
            <i class="fas fa-plane-departure"></i>
            <span>TRAVEL SAAS</span>
        </a>
        
        <ul class="nav-menu">
    <?php if($_SESSION['user_role'] == 'SuperAdmin'): ?>
        <!-- SUPER ADMIN MENU -->
         <li class="nav-item"><a href="dashboard.php" class="nav-link active"><i class="fas fa-home"></i> Dashboard</a></li>
        <li class="nav-item"><a href="admin_dashboard.php" class="nav-link "><i class="fas fa-chart-line"></i> SaaS Overview</a></li>
        <li class="nav-item"><a href="manage_agencies.php" class="nav-link"><i class="fas fa-building"></i> Manage Agencies</a></li>
        <li class="nav-item"><a href="saas_revenue.php" class="nav-link"><i class="fas fa-file-invoice-dollar"></i> Revenue & Payments</a></li>
         <li class="nav-item"><a href="generate_invoice.php" class="nav-link" style="color: #1cc88a;"><i class="fas fa-file-invoice-dollar"></i> Generate New Bill</a></li>
         <li class="nav-item"><a href="admin_group_tickets.php" class="nav-link" style="color: #3498db;"><i class="fas fa-plane-arrival"></i> B2B Group Inventory</a></li>
    <li class="nav-item"><a href="broadcast.php" class="nav-link"><i class="fas fa-bullhorn"></i> Send Announcements</a></li>
    <li class="nav-item"><a href="profile.php" class="nav-link"><i class="fas fa-user-shield"></i> My Profile</a></li>
    <?php else: ?>
        <!-- AGENCY MENU -->
        <li class="nav-item"><a href="dashboard.php" class="nav-link active"><i class="fas fa-home"></i> Dashboard</a></li>
        <li class="nav-item"><a href="clients.php" class="nav-link"><i class="fas fa-users"></i> My Clients</a></li>
        <li class="nav-item"><a href="queries.php" class="nav-link"><i class="fas fa-question-circle"></i> Enquiries</a></li>
        <?php if($_SESSION['user_role'] == 'AgencyOwner'): ?>
    <li class="nav-item"><a href="staff.php" class="nav-link"><i class="fas fa-user-tie"></i> Manage Staff</a></li>
<?php endif; ?>
        <li class="nav-item"><a href="marketplace.php" class="nav-link" style="background: rgba(28, 200, 138, 0.1); color: #1cc88a;"><i class="fas fa-shopping-cart"></i> B2B Marketplace</a></li>
        <li class="nav-item"><a href="umrah_vouchers.php" class="nav-link"><i class="fas fa-kaaba"></i> Umrah Vouchers</a></li>
        <li class="nav-item"><a href="ticket_vouchers.php" class="nav-link"><i class="fas fa-ticket-alt"></i> Ticket Vouchers</a></li>
        <li class="nav-item"><a href="posters.php" class="nav-link"><i class="fas fa-image"></i> Poster Maker</a></li>
        <li class="nav-item"><a href="ledger.php" class="nav-link"><i class="fas fa-wallet"></i> Clients Account</a></li>
        <li class="nav-item">
    <a href="agency_profile.php" class="nav-link" style="background: rgba(78, 115, 223, 0.1); color: #4e73df;">
        <i class="fas fa-cog"></i> Agency Settings
    </a>
</li>
    <?php endif; ?>
</ul>

        <?php if($_SESSION['user_role'] == 'SuperAdmin'): ?>

        <?php endif; ?>

        <div style="position: absolute; bottom: 20px; width: 100%;">
            <li class="nav-item" style="list-style: none;"><a href="logout.php" class="nav-link" style="color: #ff7675;"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </div>
    </div>


    <div class="main-content">
        <h1>Settings & Branding</h1>
        <p style="color: #64748b; margin-bottom: 30px;">Manage your agency's identity and your login security.</p>

        <?php if(isset($_GET['msg']) && $_GET['msg'] == 'success'): ?>
            <div class="alert alert-success" style="display:block;">Settings updated successfully! Your vouchers now show updated details.</div>
        <?php endif; ?>

        <form action="handle_agency_profile.php" method="POST" enctype="multipart/form-data">
            <div style="display: grid; grid-template-columns: 1fr 1.5fr; gap: 30px;">
                
                <!-- LEFT: LOGO & BRANDING -->
                <div>
                    <div class="card">
                        <div class="section-title"><i class="fas fa-image"></i> Agency Logo</div>
                        <div class="logo-preview-box">
                            <small>Current Voucher Logo</small>
                            <img src="<?php echo $agency['logo_path']; ?>" id="logoPreview">
                            <input type="file" name="agency_logo" accept="image/*" onchange="previewFile(this)" style="margin-top:15px; border:none; padding:0;">
                            <p style="font-size: 11px; color:#94a3b8; margin-top:10px;">Recommended: Transparent PNG (Height: 80px)</p>
                        </div>

                        <label>Public Agency Name</label>
                        <input type="text" name="agency_name" value="<?php echo $agency['agency_name']; ?>" required>
                    </div>
                </div>

                <!-- RIGHT: CONTACT & SECURITY -->
                <div>
                    <div class="card">
                        <div class="section-title"><i class="fas fa-id-card"></i> Contact Information</div>
                        <div class="form-grid">
                            <div style="grid-column: span 2;">
                                <label>Voucher Phone Numbers (use | to separate)</label>
                                <input type="text" name="phone" value="<?php echo $agency['phone']; ?>" placeholder="e.g. 0315-7662343 | 0346-6112233" required>
                            </div>
                            <div style="grid-column: span 2;">
                                <label>Official Address (Printed on Vouchers)</label>
                                <textarea name="address" rows="3" required><?php echo $agency['address']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="section-title"><i class="fas fa-shield-alt"></i> Login Security</div>
                        <div class="form-grid">
                            <div>
                                <label>Login Email</label>
                                <input type="email" name="email" value="<?php echo $user['email']; ?>" required>
                            </div>
                            <div>
                                <label>New Password (leave blank to keep)</label>
                                <input type="password" name="password" placeholder="••••••••">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div style="max-width: 300px; margin: auto;">
                <button type="submit" class="btn-save">Save All Settings</button>
            </div>
        </form>
    </div>

    <script>
        function previewFile(input){
            var file = input.files[0];
            if(file){
                var reader = new FileReader();
                reader.onload = function(){
                    document.getElementById("logoPreview").src = reader.result;
                }
                reader.readAsDataURL(file);
            }
        }
    </script>
</body>
</html>